/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.items.rock;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.api.capability.damage.DamageType;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.api.types.RockCategory;
import net.dries007.tfc.api.util.IRockObject;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemRockAxe
extends ItemAxe
implements IItemSize,
IRockObject {
    private static final Map<RockCategory, ItemRockAxe> MAP = new HashMap<RockCategory, ItemRockAxe>();
    public final RockCategory category;

    public static ItemRockAxe get(RockCategory category) {
        return MAP.get((Object)category);
    }

    public ItemRockAxe(RockCategory category) {
        super(category.getToolMaterial(), category.getToolMaterial().func_78000_c(), -3.0f);
        this.category = category;
        if (MAP.put(category, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
        this.setHarvestLevel("axe", category.getToolMaterial().func_77996_d());
        OreDictionaryHelper.register((Item)this, "axe");
        OreDictionaryHelper.register((Item)this, "axe", "stone");
        OreDictionaryHelper.register((Item)this, new Object[]{"axe", "stone", category});
        OreDictionaryHelper.registerDamageType((Item)this, DamageType.SLASHING);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("Rock type: " + (Object)((Object)this.category));
    }

    @Override
    @Nonnull
    public Size getSize(ItemStack stack) {
        return Size.LARGE;
    }

    @Override
    @Nonnull
    public Weight getWeight(ItemStack stack) {
        return Weight.MEDIUM;
    }

    @Override
    public boolean canStack(ItemStack stack) {
        return false;
    }

    @Override
    @Nullable
    public Rock getRock(ItemStack stack) {
        return null;
    }

    @Override
    @Nonnull
    public RockCategory getRockCategory(ItemStack stack) {
        return this.category;
    }
}

